/*
 * Decompiled with CFR 0.152.
 */
package com.utility;

import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnectInfo;
import com.utility.TncJdbc;
import com.utility.TncLog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.jetbrains.annotations.NotNull;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class DbConnection {
    private final LoginDto myConfig = LoginDto.builder().build();
    private final TncLog log;
    private final Map<String, DbConnectInfo> perSerialDataSources = new ConcurrentHashMap();

    public DbConnection(TncLog log) {
        this.log = log;
        if (!this.getUserConfig(this.myConfig)) {
            return;
        }
        this.getJdbcTemplate(null);
    }

    public TncJdbc getJdbcTemplate() {
        return (TncJdbc)this.recycleDbConnectInfo(this.setToken()).getJdbcTemplate();
    }

    public TncJdbc getJdbcTemplate(@Nullable LoginDto userLogin) {
        return (TncJdbc)this.recycleDbConnectInfo(userLogin).getJdbcTemplate();
    }

    public TransactionTemplate getTransactionTemplate(@Nullable LoginDto userLogin) {
        return this.recycleDbConnectInfo(userLogin).getTransactionTemplate();
    }

    @NonNull
    private DbConnectInfo recycleDbConnectInfo(@Nullable LoginDto userLogin) {
        DbConnectInfo dc;
        LoginDto login = userLogin == null ? LoginDto.builder().build() : userLogin;
        String nullSafeSerial = login.getJdbcKey();
        if (this.perSerialDataSources.containsKey(nullSafeSerial)) {
            dc = (DbConnectInfo)this.perSerialDataSources.get(nullSafeSerial);
        } else {
            DataSource dataSource = this.createDataSource();
            dc = DbConnectInfo.newInstance((javax.sql.DataSource)dataSource, (LoginDto)login);
            this.perSerialDataSources.put(nullSafeSerial, dc);
        }
        return dc;
    }

    private DataSource createDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setUrl("jdbc:sqlserver://" + this.myConfig.getDatabaseName());
        dataSource.setUsername(this.myConfig.getUserName());
        dataSource.setPassword(this.myConfig.getUserPass());
        dataSource.setTestOnBorrow(true);
        dataSource.setTestWhileIdle(true);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setTimeBetweenEvictionRunsMillis(3600000);
        return dataSource;
    }

    public boolean isDataSourceNotSet(@Nullable LoginDto userLogin) {
        return ConvertStr.isNullOrEmpty((String)this.recycleDbConnectInfo(userLogin).getApacheDataSource().getUsername());
    }

    public String getDbNameSql(String dbName) {
        if (ConvertStr.isNullOrEmpty((String)dbName)) {
            try {
                return this.setToken().makeUseDbSql();
            }
            catch (Throwable ignored) {
                return " USE MASTER \n";
            }
        }
        return " USE " + dbName + " \n";
    }

    public LoginDto getConfig() {
        return this.myConfig;
    }

    public LoginDto setToken() {
        return (LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
    }

    private void closeConnection(JdbcTemplate jdbcTemplate) {
        ((DataSource)Objects.requireNonNull(jdbcTemplate.getDataSource())).close();
    }

    @NotNull
    public DataSource recycleDataSource(LoginDto myLogin) {
        DataSource ds = new DataSource();
        DataSource recycledDs = this.recycleDbConnectInfo(myLogin).getApacheDataSource();
        ds.setUrl(Objects.requireNonNull(recycledDs).getUrl());
        ds.setUsername(recycledDs.getUsername());
        ds.setPassword(this.myConfig.getUserPass());
        String dbname = myLogin.getDatabaseName();
        if (dbname.indexOf("]") > 0) {
            dbname = dbname.substring(1, dbname.indexOf("]"));
        }
        ds.setDefaultCatalog(dbname);
        return ds;
    }

    private boolean getUserConfig(LoginDto myLoginDto) {
        StringBuilder inputFileName = new StringBuilder("../Config.udl");
        try {
            String inLine;
            FileReader inputFileReader;
            try {
                inputFileReader = new FileReader(inputFileName.toString());
            }
            catch (IOException ex) {
                inputFileReader = new FileReader("Config.udl");
            }
            BufferedReader inputStream = new BufferedReader(inputFileReader);
            while ((inLine = inputStream.readLine()) != null) {
                inputFileName.append(inLine);
            }
            inputStream.close();
            int index = inputFileName.indexOf("U\u0000s\u0000e\u0000r\u0000 \u0000I\u0000D") + 16;
            String inputStreamUser = inputFileName.substring(index);
            int LUserIndex = inputStreamUser.indexOf(";");
            inputStreamUser = inputStreamUser.substring(0, LUserIndex);
            index = inputFileName.indexOf("P\u0000a\u0000s\u0000s\u0000w\u0000o\u0000r\u0000d") + 18;
            String inputStreamPass = inputFileName.substring(index);
            int LPassIndex = inputStreamPass.indexOf(";");
            inputStreamPass = inputStreamPass.substring(0, LPassIndex);
            index = inputFileName.indexOf("D\u0000a\u0000t\u0000a\u0000 \u0000S\u0000o\u0000u\u0000r\u0000c\u0000e") + 24;
            String inputStreamDS = inputFileName.substring(index);
            inputStreamUser = inputStreamUser.replace("\u0000", "");
            inputStreamPass = inputStreamPass.replace("\u0000", "");
            inputStreamDS = inputStreamDS.replace("\u0000", "");
            myLoginDto.setDatabaseName(inputStreamDS);
            myLoginDto.setUserName(inputStreamUser);
            myLoginDto.setUserPass(inputStreamPass);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    private void addDefaultUser(LoginDto myLogin) {
        this.getJdbcTemplate(myLogin).execute("Insert Into UserDb (name,PasWord,SuperVizor,UserCodeInc,SaveSpdSel,DeActive) Select 'TncCloud','1',0,-10,0,1 From UserDb ");
    }

    public boolean createDataBase(LoginDto myLogin) {
        String dbName = "S" + myLogin.getSerial() + "_" + myLogin.getDatabaseName();
        myLogin.setDatabaseName("[" + dbName + "]");
        TncJdbc jdbcTemplate = this.getJdbcTemplate(myLogin);
        this.closeConnection((JdbcTemplate)jdbcTemplate);
        String sqlStr = "Select Count(*) cnt  from Master..sysdatabases where name='" + dbName + "'";
        SqlRowSet rs = jdbcTemplate.queryForRowSet("!!!" + sqlStr);
        jdbcTemplate = this.getJdbcTemplate(myLogin);
        if (!rs.next()) {
            return false;
        }
        if (rs.getInt("cnt") != 0) {
            sqlStr = "select * from dbo.sysobjects where id = object_id(N'[dbo].[USERDB]')";
            rs = jdbcTemplate.queryForRowSet(sqlStr);
            if (!rs.next()) {
                this.log.error("dbName: " + dbName + " - #createDataBase isRestoredValid = false drop database");
                this.dropDatabase(jdbcTemplate, dbName);
            } else {
                return false;
            }
        }
        jdbcTemplate.executeOnDefaultDb("CREATE DATABASE " + dbName);
        try {
            String mdfFilePath = "";
            String ldfFilePath = "";
            SqlRowSet rs1 = jdbcTemplate.queryForRowSet("!!!Select physical_name from " + dbName + ".sys.database_files");
            while (rs1.next()) {
                if ("".equals(mdfFilePath)) {
                    mdfFilePath = rs1.getString("physical_name");
                    continue;
                }
                if (!"".equals(ldfFilePath)) continue;
                ldfFilePath = rs1.getString("physical_name");
            }
            assert (mdfFilePath != null);
            String bakFileName = mdfFilePath.substring(0, mdfFilePath.lastIndexOf("\\")) + "/Holoo";
            jdbcTemplate.executeOnDefaultDb("Restore database " + dbName + " from disk= N'" + bakFileName + "' \n  with replace , FILE = 1 , MOVE N'Holoo_Data' To N'" + mdfFilePath + "',\n                            MOVE N'Holoo_Log'  To N'" + ldfFilePath + "' ");
            this.addDefaultUser(myLogin);
            this.log.error("dbName: " + dbName + " - #createDataBase DATABASE RESTORED SUCCESSFULLY");
            return true;
        }
        catch (Exception ex) {
            this.log.error("dbName: " + myLogin.getDatabaseName() + " - #createDataBase create db Exception: " + ex);
            this.dropDatabase(jdbcTemplate, dbName);
            return false;
        }
    }

    private void dropDatabase(TncJdbc jdbcTemplate, String dbName) {
        jdbcTemplate.execute("USE [master] \n ALTER DATABASE " + dbName + " SET SINGLE_USER WITH ROLLBACK IMMEDIATE \n ");
        jdbcTemplate.execute("USE [master] \n ALTER DATABASE " + dbName + " SET multi_user WITH ROLLBACK IMMEDIATE \n ");
        jdbcTemplate.execute("USE [master] \n  Drop Database " + dbName);
    }
}

